/**
 * Copyright (C) 2008 Institut fuer Telematik, Universitaet Karlsruhe (TH)
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file p2psip.h
 * @author Ingmar Baumgart
 */

#include "../../str.h"
#include "../../ut.h"

extern str p2pns_host;
extern int p2pns_port;

int pw_check(struct sip_msg* msg, char* par1, char* par2);

int p2pns_resolve(struct sip_msg* msg, char* par1, char* par2);
int p2pns_register(struct sip_msg* msg, char* par1, char* par2);
int p2pns_lookup(struct sip_msg* msg, char* par1, char* par2);
int p2pns_save(struct sip_msg* msg, char* par1, char* par2);
static inline int rewrite_ruri(struct sip_msg* _m, char* _s);

static int p2psip_fixup(void** param, int param_no);
