/**
 * Copyright (C) 2008 Institut fuer Telematik, Universitaet Karlsruhe (TH)
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file xmlrpc_connect.cpp
 * @author Ingmar Baumgart
 */

#include "xmlrpc++/XmlRpc.h"
#include "xmlrpc_connect.h"
#include <iostream>
using namespace XmlRpc;

extern "C"
{

int p2pns_register_xmlrpc(str name, str value, char* host, int port)
{
    //XmlRpc::setVerbosity(2);

    XmlRpcValue result;
    // connect to P2PNS
    XmlRpcClient c(host, port);

    // Call the put method
    XmlRpcValue params;

    char tmpbuf1[256], tmpbuf2[256];
    strncpy(tmpbuf1, name.s, name.len);
    tmpbuf1[name.len] = 0;
    strncpy(tmpbuf2, value.s, value.len);
    tmpbuf2[value.len] = 0;

    params[0] = XmlRpcValue(name.s, name.len);
    params[1] = XmlRpcValue(value.s, value.len);
    params[2] = 3600*24; //TTL

    std::cout << "P2PNS REGISTER Call: " << std::string(tmpbuf1)
              << "," << std::string(tmpbuf2) << std::endl;

    try {
        if (c.execute("register", params, result) && (!c.isFault())) {
            // ...
        } else {
            std::cout << "Error calling 'register':"
                      << result["faultString"] << std::endl;
            c.close();
            return -1;
        }
    } catch (const XmlRpcException& fault) {
        std::cout << "P2PNS REGISTER fault %s." << fault.getMessage();
        c.close();
        return -1;
    }

    std::cout << "P2PNS REGISTER Response: OK" << std::endl;


    c.close();
    return int(result);
}

int p2pns_resolve_xmlrpc(char* name, char* value, char* host, int port)
{

    //XmlRpc::setVerbosity(2);

    XmlRpcValue result, params;

    // connect to P2PNS
    XmlRpcClient c(host, port);

    // Call the get method
    params[0] = XmlRpcValue(name, strlen(name));

    std::cout << "P2PNS RESOLVE Call: " << std::string(name) << std::endl;

    try {
        if (c.execute("resolve", params, result) && (!c.isFault())) {
            // ...
        } else {
            std::cout << "Error calling 'resolve':" << result["faultString"]
                      << std::endl;
            c.close();
            return -1;
        }
    } catch (const XmlRpcException& fault) {
        std::cout << "P2PNS RESOLVE fault %s." << fault.getMessage()
                  << std::endl;
        c.close();
        return -1;
    }

    XmlRpcValue::BinaryData& data = result[0];

    strncpy(value, &(data[0]), data.size());

    std::cout << "P2PNS RESOLVE Response: " << std::string(value)
              << std::endl;

    c.close();
    return 0;
}

}
